unit Print_Preview_U;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Drawing.Printing,
  System.Windows.Forms, System.Data;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Button1: System.Windows.Forms.Button;
    Button2: System.Windows.Forms.Button;
    Button3: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
    procedure Button3_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    FStoredPageSettings: PageSettings;
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

uses PrintDoc, System.Io;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.Button2 := System.Windows.Forms.Button.Create;
  Self.Button3 := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(32, 24);
  Self.Button1.Name := 'Button1';
  Self.Button1.TabIndex := 0;
  Self.Button1.Text := 'Print';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // Button2
  // 
  Self.Button2.Location := System.Drawing.Point.Create(136, 24);
  Self.Button2.Name := 'Button2';
  Self.Button2.TabIndex := 1;
  Self.Button2.Text := 'Settings';
  Include(Self.Button2.Click, Self.Button2_Click);
  // 
  // Button3
  // 
  Self.Button3.Location := System.Drawing.Point.Create(232, 24);
  Self.Button3.Name := 'Button3';
  Self.Button3.TabIndex := 2;
  Self.Button3.Text := 'Preview';
  Include(Self.Button3.Click, Self.Button3_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(408, 238);
  Self.Controls.Add(Self.Button3);
  Self.Controls.Add(Self.Button2);
  Self.Controls.Add(Self.Button1);
  Self.Name := 'TWinForm';
  Self.Text := 'Print Preview';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.Button3_Click(sender: System.Object; e: System.EventArgs);
var
  pd: TTextFilePrintDocument;
  aStream: StreamReader;
  dlg: PrintPreviewDialog;
begin

  aStream:= StreamReader.Create('PrintMe.txt');
  try
    pd:= TTextFilePrintDocument.Create(aStream); //Assumes the default printer

    if (FStoredPageSettings <> nil) then
      pd.DefaultPageSettings:= FStoredPageSettings;

    dlg:= PrintPreviewDialog.Create;
    dlg.Document:= pd;
    dlg.ShowDialog;
  finally
    aStream.Close;
  end;
end;

procedure TWinForm.Button2_Click(sender: System.Object; e: System.EventArgs);
var
  psDlg: PageSetupDialog;
begin
  psDlg:= PageSetupDialog.Create;

  if (FStoredPageSettings = nil) then
    FStoredPageSettings:= PageSettings.Create;

  psDlg.PageSettings:= FStoredPageSettings ;
  psDlg.ShowDialog;
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  pd: TTextFilePrintDocument;
  aStream: StreamReader;
  dlg: PrintDialog;
  dr: System.Windows.Forms.DialogResult;
begin
  try
    aStream:= StreamReader.Create('PrintMe.txt');
    try
      pd:= TTextFilePrintDocument.Create(aStream); //Assumes the default printer

      dlg:= PrintDialog.Create;
      dlg.Document:= pd;
      dr:= dlg.ShowDialog;

      if (dr = System.Windows.Forms.DialogResult.OK) then
      begin
        // You can then use this custom PageSettings instance when the user prints the document.
        if (FStoredPageSettings <> nil) then
          pd.DefaultPageSettings:= FStoredPageSettings;
        pd.Print;
        MessageBox.Show('Document printed!');
      end;
    finally
      aStream.Close;
    end;
  except
    on E: System.Exception do
      MessageBox.Show('An error occurred printing the file - ' + E.Message);
  end;
end;

end.
